/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import java.util.Vector;

public class ConversationList {
    private Vector conversations = new Vector();
    protected Agent myAgent = null;
    protected int cnt = 0;
    private MessageTemplate myTemplate = new MessageTemplate(new MessageTemplate.MatchExpression(){

        public boolean match(ACLMessage msg) {
            String convId = msg.getConversationId();
            return convId == null || !ConversationList.this.conversations.contains(convId);
        }
    });

    public ConversationList(Agent a) {
        this.myAgent = a;
    }

    public String registerConversation() {
        String id = this.createConversationId();
        this.conversations.addElement(id);
        return id;
    }

    public void registerConversation(String convId) {
        if (convId != null) {
            this.conversations.addElement(convId);
        }
    }

    public void deregisterConversation(String convId) {
        if (convId != null) {
            this.conversations.removeElement(convId);
        }
    }

    public void clear() {
        this.conversations.removeAllElements();
    }

    public MessageTemplate getMessageTemplate() {
        return this.myTemplate;
    }

    protected String createConversationId() {
        return this.myAgent.getName() + this.cnt++;
    }
}

